import IGetCrossSaleHotelsRequestParamsV3 from 'server/api/HotelsCrossSaleApi/types/IGetCrossSaleHotelsRequestParamsV3';
import {TGetCrossSaleHotelsResponse} from 'server/api/HotelsCrossSaleApi/types/TGetCrossSaleHotelsResponse';

import fetchHotelsCrossSaleV3 from 'hooks/useHotelsCrossSale/utilities/fetchHotelsCrossSale/utilities/fetchHotelsCrossSaleV3';
import fetchHotelsCrossSaleV1 from 'hooks/useHotelsCrossSale/utilities/fetchHotelsCrossSale/utilities/fetchHotelsCrossSaleV1';

export default function fetchHotelsCrossSale(
    params: IGetCrossSaleHotelsRequestParamsV3,
    useOffersEndpoint: boolean,
): Promise<TGetCrossSaleHotelsResponse | undefined> {
    if (useOffersEndpoint) {
        return fetchHotelsCrossSaleV3(params);
    }

    return fetchHotelsCrossSaleV1(params);
}
