import IGetCrossSaleHotelsRequestParamsV3 from 'server/api/HotelsCrossSaleApi/types/IGetCrossSaleHotelsRequestParamsV3';
import IGetCrossSaleHotelsResponseV1 from 'server/api/HotelsCrossSaleApi/types/IGetCrossSaleHotelsResponseV1';

import {getAttributionParams} from 'projects/hotels/utilities/getAttributionParams/getAttributionParams';

import {hotelsCrossSaleService} from 'serviceProvider';

export default async function fetchHotelsCrossSaleV1(
    params: IGetCrossSaleHotelsRequestParamsV3,
): Promise<IGetCrossSaleHotelsResponseV1> {
    const result = await hotelsCrossSaleService
        .provider()
        .getCrossSaleHotelsV1({
            ...params,
            ...getAttributionParams(),
            settlementId: params.pointKey,
        });

    if (!result.hasData) {
        throw new Error('No data');
    }

    return result;
}
