import {SECOND} from 'utilities/dateUtils/constants';

import IGetCrossSaleHotelsResponseV3 from 'server/api/HotelsCrossSaleApi/types/IGetCrossSaleHotelsResponseV3';
import IGetCrossSaleHotelsRequestParamsV3 from 'server/api/HotelsCrossSaleApi/types/IGetCrossSaleHotelsRequestParamsV3';

import {getAttributionParams} from 'projects/hotels/utilities/getAttributionParams/getAttributionParams';
import {delay} from 'utilities/async/delay';

import {hotelsCrossSaleService} from 'serviceProvider';

export default async function fetchHotelsCrossSaleV3(
    params: IGetCrossSaleHotelsRequestParamsV3,
): Promise<IGetCrossSaleHotelsResponseV3 | undefined> {
    let triesCount = 0;

    // eslint-disable-next-line no-constant-condition
    while (true) {
        const response = await hotelsCrossSaleService
            .provider()
            .getCrossSaleHotelsV3({
                ...params,
                ...getAttributionParams(),
            });

        triesCount++;

        if (
            response?.searchProgress?.offerSearchProgress?.finished ||
            triesCount > 10
        ) {
            return response;
        }

        await delay(
            response?.searchProgress.nextPollingRequestDelayMs ?? SECOND,
        );
    }
}
