import {useSelector} from 'react-redux';

import {RU_GEO_ID} from 'constants/common';

import {getUserGeoLocation} from 'selectors/common/userInfoSelector';

import * as i18nBlock from 'i18n/common-support';

const MOSCOW_GEO_ID = 213;

function mapSupportPhoneByGeoId(geoId?: number, countryId?: number): string {
    if (!geoId) {
        return i18nBlock.phoneDotDefault();
    }

    if (geoId === MOSCOW_GEO_ID) {
        return i18nBlock.phoneDotMoscow();
    }

    if (countryId === RU_GEO_ID) {
        return i18nBlock.phoneDotRussia();
    }

    return i18nBlock.phoneDotGlobal();
}

export const useSupportPhone = (): string => {
    const geoLocation = useSelector(getUserGeoLocation);

    return mapSupportPhoneByGeoId(geoLocation.geoId, geoLocation.countryId);
};
