/**
 * Hook нужен для того, чтобы указывать уникальные айдишники для компонент
 * на основе lego-components.
 *
 * TLDR: lego-on-react и lego-components генерируют id одинакового формата,
 * из-за чего может быть пересечение и неуникальность, которая ломает логику.
 *
 * Полная копипаста из lego-components.
 *
 * @see https://st.yandex-team.ru/TRAVELFRONT-1804#5db878c429af1d001decdd54
 * @see https://a.yandex-team.ru/arcadia/frontend/packages/lego-components/website/content/hooks/use-uniq-id
 */

import {createContext, useState, useContext} from 'react';

interface ISource {
    value: number;
}

const createSource = (): ISource => ({
    value: 1,
});

const counter = createSource();
const source = createContext(createSource());
const getId = (source: ISource): number => source.value++;

const generateUniqId = (context: ISource, prefix = ''): string => {
    const id = getId(context || counter);

    return `${prefix}${id}`;
};

export const useUniqId = (prefix: string): string => {
    const [id] = useState(generateUniqId(useContext(source), prefix));

    return id;
};
