import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HotelStarRatingIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 10 10"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#a2bab121__clip0_30514_5119)">
            <path
                d="M4.98995 8.20757L7.26245 9.39257C7.8687 9.70882 8.45245 9.28882 8.33745 8.61757L7.9037 6.10757C7.90745 6.13257 7.9162 6.11007 7.8962 6.12757L9.73745 4.35007C10.2275 3.87507 10.0037 3.19382 9.32495 3.09632L6.78745 2.72882C6.81245 2.73257 6.7937 2.71882 6.8037 2.74132L5.66246 0.456318C5.36245 -0.152432 4.63745 -0.152432 4.33745 0.456318L3.19995 2.74132C3.21246 2.71882 3.19121 2.73257 3.2162 2.72882L0.674955 3.09632C-0.0025446 3.19382 -0.225045 3.87507 0.262455 4.34882L2.10496 6.12507C2.08621 6.10757 2.09246 6.13007 2.09871 6.10507L1.66371 8.61757C1.54871 9.28507 2.13246 9.70507 2.7387 9.39257L5.0112 8.20507C4.98995 8.21757 5.0137 8.21757 4.9912 8.20507L4.98995 8.20757Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="a2bab121__clip0_30514_5119">
                <rect width={10} height={10} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

HotelStarRatingIcon.defaultProps = {
    width: 10,
    height: 10,
    fill: 'currentColor',
};

export default HotelStarRatingIcon;
