import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SearchIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 10 10"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M3.90625 7.8125C1.74889 7.8125 0 6.06361 0 3.90625C0 1.74889 1.74889 0 3.90625 0C6.06361 0 7.8125 1.74889 7.8125 3.90625C7.8125 4.75936 7.53902 5.54859 7.07495 6.19107L9.50444 8.62056C9.74852 8.86464 9.74852 9.26036 9.50444 9.50444C9.26036 9.74852 8.86464 9.74852 8.62056 9.50444L6.19107 7.07495C5.54859 7.53902 4.75936 7.8125 3.90625 7.8125ZM3.90625 6.5625C5.37326 6.5625 6.5625 5.37326 6.5625 3.90625C6.5625 2.43924 5.37326 1.25 3.90625 1.25C2.43924 1.25 1.25 2.43924 1.25 3.90625C1.25 5.37326 2.43924 6.5625 3.90625 6.5625Z"
            fill={props.fill}
        />
    </svg>
);

SearchIcon.defaultProps = {
    width: 10,
    height: 10,
    fill: 'currentColor',
};

export default SearchIcon;
