import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const StarIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 11 10"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M4.98983 8.20761L7.26228 9.39258C7.86851 9.70883 8.45225 9.28884 8.33725 8.6176L7.90351 6.10766C7.90726 6.13266 7.91601 6.11016 7.89601 6.12766L9.73722 4.35021C10.2272 3.87522 10.0035 3.19398 9.32473 3.09649L6.78729 2.729C6.81229 2.73275 6.79354 2.719 6.80354 2.7415L5.66232 0.456551C5.36232 -0.152184 4.63734 -0.152184 4.33735 0.456551L3.19988 2.7415C3.21238 2.719 3.19113 2.73275 3.21613 2.729L0.674939 3.09649C-0.00254453 3.19398 -0.225039 3.87522 0.262449 4.34896L2.1049 6.12516C2.08615 6.10766 2.0924 6.13016 2.09865 6.10516L1.66366 8.6176C1.54867 9.28509 2.1324 9.70508 2.73864 9.39258L5.01108 8.20511C4.98983 8.21761 5.01358 8.21761 4.99108 8.20511L4.98983 8.20761Z"
            fill={props.fill}
        />
    </svg>
);

StarIcon.defaultProps = {
    width: 10,
    height: 10,
    fill: 'currentColor',
};

export default StarIcon;
