import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BurgerIcon = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 16 16" fill="none" focusable={false} {...props}>
        <rect y={7} width={16} height={2} rx={1} fill={props.fill} />
        <rect y={2} width={16} height={2} rx={1} fill={props.fill} />
        <rect y={12} width={16} height={2} rx={1} fill={props.fill} />
    </svg>
);

BurgerIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default BurgerIcon;
