import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BusIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7.78137 2.15994C8.12447 2.22205 8.46448 2.30214 8.8 2.4C9.00317 2.46389 9.18063 2.59098 9.30654 2.76276C9.43245 2.93453 9.50023 3.14202 9.5 3.355V5.5C9.5 5.5 9.5 6.5 8 6.5H4C2.50813 6.5 2.50004 5.5108 2.5 5.50009V3.355C2.49977 3.14202 2.56755 2.93453 2.69346 2.76276C2.81937 2.59098 2.99683 2.46389 3.2 2.4C3.53552 2.30214 3.87553 2.22206 4.21863 2.15994L4.27 2.315C4.33623 2.51455 4.46368 2.68816 4.63422 2.81113C4.80477 2.9341 5.00974 3.00019 5.22 3H6.78C6.99026 3.00019 7.19523 2.9341 7.36578 2.81113C7.53632 2.68816 7.66377 2.51455 7.73 2.315L7.78137 2.15994ZM6 1C4.95767 1 3.92063 1.14815 2.92 1.44C2.50911 1.56451 2.1492 1.81793 1.89348 2.1628C1.63776 2.50766 1.4998 2.92567 1.5 3.355V11H3.47L3.97 10H8.04L8.54 11H10.5V3.355C10.5002 2.92567 10.3622 2.50766 10.1065 2.1628C9.8508 1.81793 9.49089 1.56451 9.08 1.44C8.07937 1.14815 7.04233 1 6 1ZM2.5 7.5V8.5H4.5C4.5 8.23478 4.39464 7.98043 4.20711 7.79289C4.01957 7.60536 3.76522 7.5 3.5 7.5H2.5ZM9.5 8.5V7.5H8.5C8.23478 7.5 7.98043 7.60536 7.79289 7.79289C7.60536 7.98043 7.5 8.23478 7.5 8.5H9.5Z"
            fill={props.fill}
        />
    </svg>
);

BusIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default BusIcon;
