import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CloseIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M4.5858 6L1.2928 2.7071C0.9024 2.3166 0.9024 1.6834 1.2928 1.2929C1.6834 0.9024 2.3166 0.9024 2.7071 1.2929L6 4.5858L9.2929 1.2928C9.6834 0.9024 10.3166 0.9024 10.7071 1.2928C11.0976 1.6834 11.0976 2.3166 10.7071 2.7071L7.4142 6L10.7072 9.2929C11.0976 9.6834 11.0976 10.3166 10.7072 10.7071C10.3166 11.0976 9.6834 11.0976 9.2929 10.7071L6 7.4142L2.7071 10.7072C2.3166 11.0976 1.6834 11.0976 1.2929 10.7072C0.9024 10.3166 0.9024 9.6834 1.2929 9.2929L4.5858 6Z"
            fill={props.fill}
        />
    </svg>
);

CloseIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default CloseIcon;
