import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ConnectionIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8.92965 1.98428C9.45738 2.02983 9.91541 1.62142 9.95896 1.07306C9.99912 0.524575 9.60647 0.048253 9.07863 0.00294101C8.55522 -0.038848 8.09368 0.369567 8.05387 0.917927C8.01009 1.46276 8.40262 1.94285 8.92965 1.98428Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8.05056 2.26368C8.29131 2.11171 8.53707 2.16601 8.79137 2.18885C9.11851 2.21533 9.38845 2.42683 9.55214 2.68436L10.5151 4.67335L11.8308 5.61507C11.9435 5.70581 12.0126 5.84952 11.998 6.0083C11.98 6.25417 11.7726 6.43943 11.5366 6.41671C11.4639 6.41294 11.4057 6.38258 11.3402 6.35233L9.9045 5.32376C9.86095 5.28598 9.82441 5.24066 9.79557 5.19159L9.43573 4.44667L9.00222 6.42801L10.6969 8.51175C10.7368 8.57589 10.7624 8.65145 10.777 8.72701L11.2348 11.2419C11.2313 11.2986 11.2383 11.3329 11.2348 11.3781C11.2094 11.7523 10.8968 12.0247 10.5407 11.9982C10.2464 11.9717 10.0279 11.7449 9.95914 11.4648L9.52669 9.10883L8.14828 7.53931L7.82849 9.06728C7.81763 9.13871 7.7268 9.29032 7.70134 9.35081L6.37852 11.6688C6.24775 11.8804 6.0258 12.0166 5.77501 11.994C5.41517 11.9676 5.15002 11.6424 5.17898 11.2718C5.18633 11.1658 5.23 11.0564 5.26643 10.9807L6.49457 8.83647L7.58412 4.23007L6.94909 5.06282L5.92632 6.41805C5.79393 6.59103 5.54932 6.66574 5.3575 6.54864C5.14921 6.42339 5.08184 6.15018 5.20268 5.93359C5.21027 5.9167 5.22124 5.90139 5.23432 5.88244L6.43269 4.30442C6.48044 4.25206 7.48418 2.93814 7.82662 2.48939C7.89749 2.39658 8.05056 2.26368 8.05056 2.26368Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M1.71432 12C2.18771 12 2.57146 11.6162 2.57146 11.1429C2.57146 10.6695 2.18771 10.2857 1.71432 10.2857C1.24093 10.2857 0.857178 10.6695 0.857178 11.1429C0.857178 11.6162 1.24093 12 1.71432 12Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.13445 7.8438L2.97986 6.94063C2.80845 6.8066 2.56114 6.83726 2.42744 7.00883L2.26596 7.21591L2.25745 7.20905C2.08616 7.0749 1.83862 7.10556 1.70492 7.27701L0.0832606 9.35711C-0.0503212 9.52867 -0.0199402 9.77637 0.151234 9.9104L0.159745 9.91715L0.146387 9.93444C0.0125686 10.1059 0.0431861 10.3537 0.21436 10.4877L1.05202 11.1429C1.13123 10.9089 1.34992 10.7395 1.61011 10.7395C1.83637 10.7395 2.0306 10.8682 2.13014 11.055L4.20231 8.39734C4.33613 8.22565 4.30563 7.97784 4.13445 7.8438Z"
            fill={props.fill}
        />
    </svg>
);

ConnectionIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default ConnectionIcon;
