import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FlightIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.5 0.810163C10.87 0.695163 11.155 0.680163 11.25 0.775163C11.345 0.870163 11.33 1.15516 11.215 1.52516C10.9685 2.27608 10.5528 2.96034 10 3.52516L9 4.52516L9.5 11.0252L9 11.5252L6.81156 6.7106C6.40337 7.10257 5.96483 7.46189 5.5 7.78516C5.22085 8.00084 4.9267 8.19496 4.62015 8.36623L5 11.0252L4.5 11.5252L3 9.02516L0.5 7.52516L1 7.02516L3.66211 7.40546C3.83286 7.09913 4.0259 6.80487 4.24 6.52516C4.61499 5.98902 5.03663 5.48707 5.5 5.02516L8.5 2.02516C9.06482 1.47234 9.74908 1.05665 10.5 0.810163ZM1 2.52516L0.5 3.02516L4.695 4.93016C5.27399 4.22163 5.9094 3.56113 6.595 2.95516L1 2.52516Z"
            fill={props.fill}
        />
    </svg>
);

FlightIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default FlightIcon;
