import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const GeolocationIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M0.326904 5.34312L4.6959 7.52812L6.8819 11.8981L11.9779 0.245117L0.326904 5.34312Z"
            fill={props.fill}
        />
    </svg>
);

GeolocationIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default GeolocationIcon;
