import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HotelIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M2.00004 4.61599C1.73526 4.75215 1.50596 4.95113 1.33327 5.19734C1.10218 5.52682 0.985158 5.92283 1.00004 6.325V11H2.50004L3.00004 10H9.00004L9.50004 11H11V6.325C11.0149 5.92283 10.8979 5.52682 10.6668 5.19734C10.4941 4.95113 10.2648 4.75215 10 4.61599V4C10 3.06812 10 2.60218 9.8478 2.23463C9.64481 1.74458 9.25546 1.35523 8.76541 1.15224C8.39787 1 7.93193 1 7.00004 1H5.00004C4.06816 1 3.60222 1 3.23467 1.15224C2.74462 1.35523 2.35527 1.74458 2.15228 2.23463C2.00004 2.60218 2.00004 3.06812 2.00004 4V4.61599ZM8.25004 4.16785C6.76057 3.91732 5.23952 3.91732 3.75004 4.16785V2.88C3.74907 2.83256 3.75789 2.78543 3.77596 2.74155C3.79402 2.69768 3.82095 2.658 3.85504 2.625C3.92286 2.56145 4.01211 2.52575 4.10504 2.525H4.18004C4.77884 2.65381 5.3879 2.7291 6.00004 2.75C6.61203 2.73075 7.22109 2.65713 7.82004 2.53H7.89504C7.98798 2.53075 8.07723 2.56645 8.14504 2.63C8.17914 2.663 8.20606 2.70268 8.22413 2.74655C8.2422 2.79043 8.25102 2.83756 8.25004 2.885V4.16785ZM2.00004 6.325V7H10V6.325C10.0047 6.14619 9.95321 5.97041 9.85276 5.82242C9.7523 5.67442 9.60795 5.56165 9.44004 5.5C7.19137 4.85991 4.80871 4.85991 2.56004 5.5C2.39213 5.56165 2.24779 5.67442 2.14733 5.82242C2.04687 5.97041 1.99536 6.14619 2.00004 6.325Z"
            fill={props.fill}
        />
    </svg>
);

HotelIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default HotelIcon;
