import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HotelStarRatingIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#a172bae4__clip0_30514_5120)">
            <path
                d="M5.98795 9.84913L8.71495 11.2711C9.44245 11.6506 10.1429 11.1466 10.0049 10.3411L9.48445 7.32913C9.48895 7.35913 9.49945 7.33213 9.47545 7.35313L11.6849 5.22013C12.2729 4.65013 12.0044 3.83263 11.1899 3.71563L8.14495 3.27463C8.17495 3.27913 8.15245 3.26263 8.16445 3.28963L6.79495 0.547631C6.43495 -0.182869 5.56495 -0.182869 5.20495 0.547631L3.83995 3.28963C3.85495 3.26263 3.82945 3.27913 3.85945 3.27463L0.809946 3.71563C-0.00305352 3.83263 -0.270054 4.65013 0.314946 5.21863L2.52595 7.35013C2.50345 7.32913 2.51095 7.35613 2.51845 7.32613L1.99645 10.3411C1.85845 11.1421 2.55895 11.6461 3.28645 11.2711L6.01345 9.84613C5.98795 9.86113 6.01645 9.86113 5.98945 9.84613L5.98795 9.84913Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="a172bae4__clip0_30514_5120">
                <rect width={12} height={12} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

HotelStarRatingIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default HotelStarRatingIcon;
