import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PlusIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6 0C5.58579 0 5.25 0.335786 5.25 0.75V5.25H0.75C0.335786 5.25 0 5.58579 0 6C0 6.41421 0.335786 6.75 0.75 6.75H5.25V11.25C5.25 11.6642 5.58579 12 6 12C6.41421 12 6.75 11.6642 6.75 11.25V6.75H11.25C11.6642 6.75 12 6.41421 12 6C12 5.58579 11.6642 5.25 11.25 5.25H6.75V0.75C6.75 0.335786 6.41421 0 6 0Z"
            fill={props.fill}
        />
    </svg>
);

PlusIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default PlusIcon;
