import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const RestaurantIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.9999 5.00008C10.3332 6.00007 9.4999 6.50007 8.49991 6.50007C7.49992 6.50007 6.6666 6.00007 5.99994 5.00008L6.18074 0.480142C6.19146 0.211992 6.41197 0.000131267 6.68033 0.000131267H6.79993L6.97493 3.5001H8.02492L8.19992 0.000131267H8.79991L8.97491 3.5001H10.0249L10.1999 0.000131267H10.3195C10.5879 0.000131267 10.8084 0.211992 10.8191 0.480142L10.9999 5.00008ZM9.29432 7.39894L9.49041 11.3207C9.49751 11.4628 9.44379 11.6011 9.3427 11.7011C9.1413 11.9004 8.86019 12 8.49939 12C8.13862 12 7.85753 11.9004 7.65614 11.7012L7.65612 11.7012C7.55499 11.6012 7.50126 11.4628 7.50836 11.3207L7.70445 7.39894C7.96943 7.46635 8.23441 7.50005 8.49939 7.50005C8.76436 7.50005 9.02934 7.46635 9.29432 7.39894ZM3.99996 0.500024V12H3.49996C2.94769 12 2.49997 11.5523 2.49997 11V7.0062C2.16664 6.48627 1.66665 6.15335 0.99999 6.00744C0.99999 3.21019 1.73097 1.24285 3.19293 0.1054C3.41087 -0.0641756 3.72502 -0.0249574 3.89459 0.19299C3.96288 0.280768 3.99996 0.388809 3.99996 0.500024Z"
            fill={props.fill}
        />
    </svg>
);

RestaurantIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default RestaurantIcon;
