import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const StarIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 13 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M5.98795 9.84937L8.71495 11.2714C9.44245 11.6509 10.1429 11.1469 10.0049 10.3414L9.48445 7.32938C9.48895 7.35938 9.49945 7.33237 9.47545 7.35337L11.6849 5.22038C12.2729 4.65037 12.0044 3.83288 11.1899 3.71588L8.14495 3.27487C8.17495 3.27937 8.15245 3.26288 8.16445 3.28988L6.79495 0.547875C6.43495 -0.182625 5.56495 -0.182625 5.20495 0.547875L3.83995 3.28988C3.85495 3.26288 3.82945 3.27937 3.85945 3.27487L0.809946 3.71588C-0.00305352 3.83288 -0.270054 4.65037 0.314946 5.21887L2.52595 7.35038C2.50345 7.32937 2.51095 7.35637 2.51845 7.32637L1.99645 10.3414C1.85845 11.1424 2.55895 11.6464 3.28645 11.2714L6.01345 9.84637C5.98795 9.86137 6.01645 9.86137 5.98945 9.84637L5.98795 9.84937Z"
            fill={props.fill}
        />
    </svg>
);

StarIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default StarIcon;
