import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ToursIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M0.555034 3.49947V3.44447C0.552293 3.4627 0.552293 3.48124 0.555034 3.49947Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M2.17194 1.85963C3.10549 1.21666 4.20208 0.851295 5.33472 0.80585C6.46736 0.760405 7.5897 1.03674 8.57176 1.60285C9.55383 2.16897 10.3554 3.00169 10.8837 4.0046C11.4121 5.0075 11.6455 6.13955 11.5569 7.26963C11.554 7.32732 11.5392 7.39198 11.5361 7.40241C11.2756 7.87596 9.17711 7.13159 6.7385 5.7687L5.45896 8.00047H4.2987L5.87771 5.26959C3.50374 3.84117 1.84269 2.39163 2.09694 1.93963C2.11737 1.90903 2.14271 1.882 2.17194 1.85963ZM6.75194 4.76463C7.47159 5.18615 8.21444 5.56675 8.97694 5.90463C9.41194 4.25463 9.24194 2.64963 8.28694 2.09963C7.33194 1.54963 5.85694 2.20463 4.64694 3.40463C5.32426 3.89457 6.0269 4.34854 6.75194 4.76463ZM11.42 3.44448C11.4191 3.45779 11.4191 3.47116 11.42 3.48448C11.4209 3.47116 11.4209 3.45779 11.42 3.44448ZM2.5 6.49948L4 8.49948H8.5C8.76522 8.49948 9.01957 8.60483 9.20711 8.79237C9.39464 8.97991 9.5 9.23426 9.5 9.49948V10.9995H8.5L7.5 9.99948H3L2 10.9995H1L2 9.31448L0 6.49948H2.5Z"
            fill={props.fill}
        />
    </svg>
);

ToursIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default ToursIcon;
