import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TrainIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.78 0.5H5.22C5.00974 0.49981 4.80477 0.565898 4.63422 0.688871C4.46368 0.811845 4.33623 0.985446 4.27 1.185L4.11154 1.66332C3.71001 1.73329 3.31221 1.82561 2.92 1.94C2.50911 2.06451 2.1492 2.31793 1.89348 2.6628C1.63776 3.00766 1.4998 3.42567 1.5 3.855V8.645C1.4998 9.07433 1.63776 9.49234 1.89348 9.8372C2.1492 10.1821 2.50911 10.4355 2.92 10.56L3.225 10.645L3.81593 9.77195C3.88063 9.70393 3.95608 9.64653 4.03955 9.6022C4.16591 9.5351 4.30679 9.50001 4.44986 9.5H4.45H7.51C7.65609 9.50043 7.79977 9.53721 7.92809 9.60705C8.0564 9.67688 8.16532 9.77756 8.245 9.9L8.745 10.65C8.86 10.625 8.97 10.595 9.08 10.56C9.49089 10.4355 9.8508 10.1821 10.1065 9.8372C10.3622 9.49234 10.5002 9.07433 10.5 8.645V3.855C10.5002 3.42567 10.3622 3.00766 10.1065 2.6628C9.8508 2.31793 9.49089 2.06451 9.08 1.94C8.68779 1.82561 8.28999 1.73329 7.88846 1.66332L7.73 1.185C7.66377 0.985446 7.53632 0.811845 7.36578 0.688871C7.19523 0.565898 6.99026 0.49981 6.78 0.5ZM9.5 5.27558V3.855C9.50023 3.64202 9.43245 3.43453 9.30654 3.26276C9.18063 3.09098 9.00317 2.96389 8.8 2.9C7.89034 2.63468 6.94757 2.5 6 2.5C5.05243 2.5 4.10967 2.63468 3.2 2.9C2.99683 2.96389 2.81937 3.09098 2.69346 3.26276C2.56755 3.43453 2.49977 3.64202 2.5 3.855V5.27558C2.72113 5.40597 3.04004 5.5 3.5 5.5H8.5C8.95996 5.5 9.27888 5.40597 9.5 5.27558ZM2.5 7V8H4.5C4.5 7.73478 4.39464 7.48043 4.20711 7.29289C4.01957 7.10536 3.76522 7 3.5 7H2.5ZM9.5 8V7H8.5C8.23478 7 7.98043 7.10536 7.79289 7.29289C7.60536 7.48043 7.5 7.73478 7.5 8H9.5ZM6.5 10H7.155C7.25889 10.0002 7.36069 10.0293 7.44899 10.0841C7.53729 10.1388 7.60862 10.217 7.655 10.31L8.5 12H7L6.5 10ZM4.845 10H5.5L5 12H3.5L4.345 10.31C4.39138 10.217 4.46271 10.1388 4.55101 10.0841C4.63931 10.0293 4.74111 10.0002 4.845 10Z"
            fill={props.fill}
        />
    </svg>
);

TrainIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default TrainIcon;
