import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TransportStopIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M2.5 11C1.67157 11 1 10.3284 1 9.5C1 8.67157 1.67157 8 2.5 8C3.32843 8 4 8.67157 4 9.5C4 10.3284 3.32843 11 2.5 11Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M5.45858 9.99967C5.48582 9.83717 5.5 9.67024 5.5 9.5C5.5 7.84315 4.15685 6.5 2.5 6.5C1.45651 6.5 0.537461 7.03275 0 7.8411L0 5H1.53846C1.79336 5 2 4.79336 2 4.53846V2.46154C2 2.20664 1.79336 2 1.53846 2H0V0H9C11.0057 0 12.0057 0.666667 12 2H11.5C11.2239 2 11 2.22386 11 2.5V5C11 5.66667 11.3333 6.33333 12 7V9.62032C12 9.82983 11.8316 9.99967 11.6239 9.99967H5.45858ZM3.46154 2C3.20664 2 3 2.20664 3 2.46154V4.53846C3 4.79336 3.20664 5 3.46154 5H5.53846C5.79336 5 6 4.79336 6 4.53846V2.46154C6 2.20664 5.79336 2 5.53846 2H3.46154ZM7.46154 2C7.20664 2 7 2.19286 7 2.43077V8.56923C7 8.80714 7.20664 9 7.46154 9H9.53846C9.79336 9 10 8.80714 10 8.56923V2.43077C10 2.19286 9.79336 2 9.53846 2H7.46154Z"
            fill={props.fill}
        />
    </svg>
);

TransportStopIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default TransportStopIcon;
