import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const YandexPlusGlyphIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7.91855 9.11391L8.71055 5.33391H11.9634C11.9876 5.55261 12 5.77486 12 6C12 9.31371 9.31371 12 6 12C2.68629 12 0 9.31371 0 6C0 2.68629 2.68629 0 6 0C6.64815 0 7.27231 0.102774 7.85705 0.292914L7.16255 3.53391H3.68855L3.31055 5.33391H6.78455L5.97455 9.11391H7.91855ZM9.59624 1.19674L9.10655 3.53391H11.4714C11.0519 2.60474 10.4028 1.80155 9.59624 1.19674Z"
            fill={props.fill}
        />
    </svg>
);

YandexPlusGlyphIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default YandexPlusGlyphIcon;
