import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const AcIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M14.5 11C15.3284 11 16 10.3284 16 9.5V3.5C16 2.67157 15.3284 2 14.5 2H1.5C0.671573 2 0 2.67157 0 3.5V9.5C0 10.3284 0.671573 11 1.5 11H2V8.5C2 8.22386 2.22386 8 2.5 8H13.5C13.7761 8 14 8.22386 14 8.5V11H14.5ZM2.5 6C2.22386 6 2 6.22386 2 6.5C2 6.77614 2.22386 7 2.5 7H13.5C13.7761 7 14 6.77614 14 6.5C14 6.22386 13.7761 6 13.5 6H2.5ZM13.5 4C13.2239 4 13 4.22386 13 4.5C13 4.77614 13.2239 5 13.5 5C13.7761 5 14 4.77614 14 4.5C14 4.22386 13.7761 4 13.5 4Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.96634 12.9872C4.96634 13.287 5.40093 13.8292 5.06044 13.9595C4.77813 14.0676 4.58993 13.9595 4.30763 13.6354C4.11943 13.4193 3.83713 13.0952 4.11943 12.555C4.21353 12.3389 5.34274 11.4746 5.34274 11.0424C5.34274 10.6102 4.58993 9.96196 4.40173 9.74588C4.21353 9.52979 4.28089 9.22102 4.49583 9.09762C5.06044 8.7735 6.47195 9.74588 6.47195 10.8263C6.47195 12 4.96634 12.555 4.96634 12.9872Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7.96634 12.9872C7.96634 13.287 8.40093 13.8292 8.06044 13.9595C7.77813 14.0676 7.58993 13.9595 7.30763 13.6354C7.11943 13.4193 6.83713 13.0952 7.11943 12.555C7.21353 12.3389 8.34274 11.4746 8.34274 11.0424C8.34274 10.6102 7.58993 9.96196 7.40173 9.74588C7.21353 9.52979 7.28089 9.22102 7.49583 9.09762C8.06044 8.7735 9.47195 9.74588 9.47195 10.8263C9.47195 12 7.96634 12.555 7.96634 12.9872Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.9663 12.9872C10.9663 13.287 11.4009 13.8292 11.0604 13.9595C10.7781 14.0676 10.5899 13.9595 10.3076 13.6354C10.1194 13.4193 9.83713 13.0952 10.1194 12.555C10.2135 12.3389 11.3427 11.4746 11.3427 11.0424C11.3427 10.6102 10.5899 9.96196 10.4017 9.74588C10.2135 9.52979 10.2809 9.22102 10.4958 9.09762C11.0604 8.7735 12.4719 9.74588 12.4719 10.8263C12.4719 12 10.9663 12.555 10.9663 12.9872Z"
            fill={props.fill}
        />
    </svg>
);

AcIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default AcIcon;
