import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const AeroexpressIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7.3022 0.896751C7.3022 0.511949 7.612 0.199997 8.00015 0.199997C8.38561 0.199997 8.69809 0.511732 8.69809 0.896751V1.59694L10.7919 3.69236L10.094 4.39083L8.69809 3.69236V6.48625H7.3022V3.69236L5.90632 4.39083L5.20837 3.69236L7.3022 1.59694V0.896751ZM1.14664 7.08755L0.481221 6.87118C0.115524 6.75227 -0.0852016 6.36102 0.0347436 5.99159C0.153858 5.62471 0.546674 5.42363 0.912574 5.54261L1.57799 5.75898L4.21637 4.41364L4.66448 5.29377L3.56934 6.4065L6.22447 7.26986L5.79312 8.59843L3.13799 7.73507L3.37042 9.27948L2.49096 9.72793L1.14663 7.08755L1.14664 7.08755ZM4.05114 15.2094C3.82513 15.5208 3.39128 15.5909 3.07726 15.3626C2.76541 15.1358 2.6957 14.6998 2.92184 14.3883L3.3331 13.8219L2.86987 10.895L3.84476 10.7405L4.56381 12.1266L6.20478 9.86634L7.33407 10.6874L5.69311 12.9477L7.23265 13.2038L7.38705 14.1794L4.46239 14.643L4.05114 15.2094ZM12.6672 13.8219L13.0785 14.3883C13.3045 14.6997 13.2371 15.1343 12.923 15.3626C12.6112 15.5893 12.1753 15.5209 11.9492 15.2094L11.5379 14.643L8.61324 14.1794L8.76765 13.2038L10.3072 12.9477L8.66622 10.6874L9.79552 9.86634L11.4365 12.1266L12.1555 10.7405L13.1304 10.895L12.6672 13.8219L12.6672 13.8219ZM14.4223 5.75898L15.0877 5.54261C15.4534 5.4237 15.8456 5.62215 15.9656 5.99159C16.0847 6.35846 15.885 6.7522 15.5191 6.87118L14.8537 7.08755L13.5093 9.72793L12.6299 9.27948L12.8623 7.73507L10.2072 8.59843L9.77582 7.26986L12.431 6.4065L11.3358 5.29377L11.7839 4.41364L14.4223 5.75898L14.4223 5.75898Z"
            fill={props.fill}
        />
    </svg>
);

AeroexpressIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default AeroexpressIcon;
