import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const AntisepticIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M7.33329 0.333333C7.33329 0.149238 7.48253 0 7.66663 0H8.33329C8.51739 0 8.66663 0.149238 8.66663 0.333333V0.54306C8.66663 0.618814 8.62172 0.687415 8.56973 0.742511C8.51872 0.796569 8.46663 0.880921 8.46663 1C8.46663 1.11908 8.51872 1.20343 8.56973 1.25749C8.62172 1.31258 8.66663 1.38119 8.66663 1.45694V1.66667C8.66663 1.85076 8.51739 2 8.33329 2H7.66663C7.48253 2 7.33329 1.85076 7.33329 1.66667V0.333333Z"
            fill={props.fill}
        />
        <path
            d="M8.00148 4.66667C11 4.66667 10.6636 3.73333 10.6636 3.73333C10.5794 3.17205 10.1061 2.69442 9.40371 2.38905C9.33119 2.35752 9.24857 2.39795 9.2257 2.47365C9.19107 2.58826 9.08547 2.66667 8.96574 2.66667H7.03543C6.91596 2.66667 6.81069 2.58815 6.77662 2.47364C6.75414 2.39805 6.67178 2.35753 6.59946 2.38897C5.89701 2.69434 5.42359 3.172 5.33938 3.73333C5.33938 3.73333 5.003 4.66667 8.00148 4.66667Z"
            fill={props.fill}
        />
        <path
            d="M7.99996 11.8333C8.82839 11.8333 9.49996 11.1618 9.49996 10.3333C9.49996 9.50491 8.82839 8.83333 7.99996 8.83333C7.17153 8.83333 6.49996 9.50491 6.49996 10.3333C6.49996 11.1618 7.17153 11.8333 7.99996 11.8333Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.83321 4.65611C4.81446 4.6341 4.78762 4.62051 4.75871 4.62051C4.70785 4.62051 4.66663 4.66174 4.66663 4.71259V14.5963C4.66663 14.8595 4.74721 15.12 4.9598 15.2752C5.36522 15.5712 6.25383 16 7.99996 16C9.74609 16 10.6347 15.5712 11.0401 15.2752C11.2527 15.12 11.3333 14.8595 11.3333 14.5963V4.71259C11.3333 4.66174 11.2921 4.62051 11.2412 4.62051C11.2123 4.62051 11.1855 4.6341 11.1667 4.65611C10.906 4.96213 10.116 5.43333 7.99996 5.43333C5.88392 5.43333 5.0939 4.96213 4.83321 4.65611ZM10.3333 10.3333C10.3333 11.622 9.28862 12.6667 7.99996 12.6667C6.7113 12.6667 5.66663 11.622 5.66663 10.3333C5.66663 9.04467 6.7113 8 7.99996 8C9.28862 8 10.3333 9.04467 10.3333 10.3333Z"
            fill={props.fill}
        />
        <path
            d="M11.8333 1C12.1094 1 12.3333 0.776142 12.3333 0.5C12.3333 0.223858 12.1094 0 11.8333 0C11.5572 0 11.3333 0.223858 11.3333 0.5C11.3333 0.776142 11.5572 1 11.8333 1Z"
            fill={props.fill}
        />
        <path
            d="M10.6666 1C10.6666 1.27614 10.4428 1.5 10.1666 1.5C9.89048 1.5 9.66663 1.27614 9.66663 1C9.66663 0.723858 9.89048 0.5 10.1666 0.5C10.4428 0.5 10.6666 0.723858 10.6666 1Z"
            fill={props.fill}
        />
        <path
            d="M11.5 2.66667C11.7761 2.66667 12 2.44281 12 2.16667C12 1.89052 11.7761 1.66667 11.5 1.66667C11.2238 1.66667 11 1.89052 11 2.16667C11 2.44281 11.2238 2.66667 11.5 2.66667Z"
            fill={props.fill}
        />
    </svg>
);

AntisepticIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default AntisepticIcon;
