import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowBackIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M2.41764 8L7.20751 12.7931C7.5979 13.1838 7.59768 13.817 7.20702 14.2073C6.81637 14.5977 6.1832 14.5975 5.79281 14.2069L0.296558 8.70687C-0.0936445 8.3164 -0.0936445 7.6836 0.296558 7.29313L5.79281 1.79313C6.1832 1.40248 6.81637 1.40226 7.20702 1.79265C7.59768 2.18304 7.5979 2.81621 7.20751 3.20687L2.41764 8Z"
            fill={props.fill}
        />
    </svg>
);

ArrowBackIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ArrowBackIcon;
