import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowLeftIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M6.41764 8L11.2075 12.7931C11.5979 13.1838 11.5977 13.817 11.207 14.2073C10.8164 14.5977 10.1832 14.5975 9.79281 14.2069L4.29656 8.70687C3.90636 8.3164 3.90636 7.6836 4.29656 7.29313L9.79281 1.79313C10.1832 1.40248 10.8164 1.40226 11.207 1.79265C11.5977 2.18304 11.5979 2.81621 11.2075 3.20687L6.41764 8Z"
            fill={props.fill}
        />
    </svg>
);

ArrowLeftIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ArrowLeftIcon;
