import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowShortRightIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M10.511 8.39134L6.81234 11.3502C6.48495 11.6121 6 11.379 6 10.9597V5.04061C6 4.6213 6.48507 4.38823 6.81243 4.65024L10.5111 7.61054C10.7613 7.81073 10.7612 8.19121 10.511 8.39134Z"
            fill={props.fill}
        />
    </svg>
);

ArrowShortRightIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ArrowShortRightIcon;
