import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BackwardIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10 11H11.007C13.213 11 15 9.21 15 7C15 4.795 13.212 3 11.007 3H4.993C2.787 3 1 4.79 1 7C1 9.205 2.788 11 4.993 11H7.333L10 13V11ZM10 9H11C12.113 9 13 8.105 13 7C13 5.888 12.105 5 11 5H5C3.887 5 3 5.895 3 7C3 8.112 3.895 9 5 9H7.333L10 7V9ZM7.333 9H5V11H7.333L6 10L7.333 9Z"
            fill={props.fill}
        />
    </svg>
);

BackwardIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default BackwardIcon;
