import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BaggageIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#bbad5f87__clip0_3763_6)">
            <path
                d="M11.0791 3.9999H4.92086C3.87763 3.9999 3 4.8473 3 5.89027V14.0034C3 14.6586 3.52946 15.411 4.11986 15.8104C4.33632 15.9569 4.6011 15.9997 4.86244 15.9997C5.14093 15.9997 5.47342 15.9997 5.93312 15.9997C6.64516 15.9997 7.03312 15.9997 7.03312 15.9997H7.76646H9.59979H9.96646C9.96646 15.9997 9.73785 15.9997 10.4333 15.9997C11.1454 15.9997 11.1667 15.9997 11.1667 15.9997C11.4089 15.9997 11.654 15.961 11.8573 15.8292C12.4655 15.435 13 14.669 13 14.0034V5.89027C13 4.8473 12.1224 3.9999 11.0791 3.9999ZM5.31699 0.472593C5.31699 0.211852 5.53226 0 5.7972 0H10.0198C10.2847 0 10.5 0.211852 10.5 0.472593V3.00022H9.73355V0.733378H6.06688V2.13392V2.97174V3.00022H5.31699V0.472593Z"
                fill={props.fill}
            />
            <path
                d="M6.00001 7.33333C6.00001 7.14924 6.22387 7 6.50001 7C6.77615 7 7.00001 7.14924 7.00001 7.33333V12.6667C7.00001 12.8508 6.77615 13 6.50001 13C6.22387 13 6.00001 12.8508 6.00001 12.6667V7.33333Z"
                fill="white"
            />
            <path
                d="M9 7.33333C9 7.14924 9.22386 7 9.5 7C9.77614 7 10 7.14924 10 7.33333V12.6667C10 12.8508 9.77614 13 9.5 13C9.22386 13 9 12.8508 9 12.6667V7.33333Z"
                fill="white"
            />
        </g>
        <defs>
            <clipPath id="bbad5f87__clip0_3763_6">
                <rect width={16} height={16} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

BaggageIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default BaggageIcon;
