import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BaggageNoSizeIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#bc868fe9__clip0_18006_4214)">
            <path
                d="M11.0791 3.9999H4.92086C3.87763 3.9999 3 4.8473 3 5.89027V14.0034C3 14.6586 3.52946 15.411 4.11986 15.8104C4.33632 15.9569 4.6011 15.9997 4.86244 15.9997C5.14093 15.9997 5.47342 15.9997 5.93312 15.9997C6.64516 15.9997 7.03312 15.9997 7.03312 15.9997H7.76646H9.59979H9.96646C9.96646 15.9997 9.73785 15.9997 10.4333 15.9997C11.1454 15.9997 11.1667 15.9997 11.1667 15.9997C11.4089 15.9997 11.654 15.961 11.8573 15.8292C12.4655 15.435 13 14.669 13 14.0034V5.89027C13 4.8473 12.1224 3.9999 11.0791 3.9999ZM5.31699 0.472593C5.31699 0.211852 5.53226 0 5.7972 0H10.0198C10.2847 0 10.5 0.211852 10.5 0.472593V3.00022H9.73355V0.733378H6.06688V2.13392V2.97174V3.00022H5.31699V0.472593Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="bc868fe9__clip0_18006_4214">
                <rect width={16} height={16} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

BaggageNoSizeIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default BaggageNoSizeIcon;
