import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BusIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.3752 2.87993C10.8326 2.96275 11.286 3.06953 11.7333 3.20001C12.0042 3.2852 12.2408 3.45465 12.4087 3.68369C12.5766 3.91272 12.667 4.18937 12.6667 4.47334V7.33334C12.6667 7.33334 12.6667 8.66668 10.6667 8.66668H5.33333C3.34574 8.66668 3.33341 7.34983 3.33333 7.3335V4.47334C3.33303 4.18937 3.4234 3.91272 3.59128 3.68369C3.75916 3.45465 3.99578 3.2852 4.26667 3.20001C4.71402 3.06953 5.16738 2.96275 5.62484 2.87993L5.69333 3.08668C5.78164 3.35275 5.95157 3.58422 6.17897 3.74818C6.40636 3.91215 6.67966 4.00026 6.96 4.00001H9.04C9.32034 4.00026 9.59364 3.91215 9.82103 3.74818C10.0484 3.58422 10.2184 3.35275 10.3067 3.08668L10.3752 2.87993ZM8 1.33334C6.61023 1.33334 5.22751 1.53087 3.89333 1.92001C3.34549 2.08602 2.8656 2.42392 2.52464 2.88374C2.18367 3.34356 1.99973 3.9009 2 4.47334V14.6667H4.62667L5.29334 13.3333H10.72L11.3867 14.6667H14V4.47334C14.0003 3.9009 13.8163 3.34356 13.4754 2.88374C13.1344 2.42392 12.6545 2.08602 12.1067 1.92001C10.7725 1.53087 9.38977 1.33334 8 1.33334ZM3.33333 10V11.3333H6C6 10.9797 5.85953 10.6406 5.60948 10.3905C5.35943 10.1405 5.02029 10 4.66667 10H3.33333ZM12.6667 11.3333V10H11.3333C10.9797 10 10.6406 10.1405 10.3905 10.3905C10.1405 10.6406 10 10.9797 10 11.3333H12.6667Z"
            fill={props.fill}
        />
    </svg>
);

BusIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default BusIcon;
