import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BusinessIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.6667 3.66667V2.33333C10.6667 1.59695 10.0697 1 9.33333 1H6.66667C5.93029 1 5.33333 1.59695 5.33333 2.33333V3.66667H0.666667C0.298477 3.66667 0 3.96514 0 4.33333V6.70448L0.168655 6.7607C2.78165 7.6317 5.39145 8.06667 8 8.06667C10.6086 8.06667 13.2184 7.6317 15.8313 6.7607L16 6.70448V4.33333C16 3.96514 15.7015 3.66667 15.3333 3.66667H10.6667ZM6.66667 2.33333V3.66667H9.33333V2.33333H6.66667Z"
            fill={props.fill}
        />
        <path
            d="M16 7.82827C13.7795 8.55311 11.5569 8.97625 9.33333 9.0971V9.66667C9.33333 10.0349 9.03486 10.3333 8.66667 10.3333H7.33333C6.96514 10.3333 6.66667 10.0349 6.66667 9.66667V9.0971C4.44305 8.97625 2.22047 8.55311 0 7.82827V12.6259C0 13.2376 0.416354 13.764 1.02032 13.8611C2.24442 14.0579 4.57033 14.3333 8 14.3333C11.4297 14.3333 13.7556 14.0579 14.9797 13.8611C15.5836 13.764 16 13.2376 16 12.6259V7.82827Z"
            fill={props.fill}
        />
    </svg>
);

BusinessIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default BusinessIcon;
