import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CallIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M1.74603 1.136C-0.958968 3.589 1.48003 8.154 4.66203 11.336C7.84303 14.517 12.415 16.962 14.868 14.257C15.038 14.069 15.326 13.657 15.73 13.024C15.8722 12.8003 15.9198 12.5292 15.8622 12.2705C15.8046 12.0117 15.6467 11.7864 15.423 11.644L12.987 10.244C12.7687 10.1189 12.5113 10.0808 12.266 10.1371C12.0208 10.1935 11.8059 10.3402 11.664 10.548C11.4773 10.8295 11.2647 11.093 11.029 11.335C9.68603 12.672 7.98903 11.481 6.25303 9.745C4.51603 8.008 3.33203 6.318 4.66903 4.975C4.87203 4.771 5.13403 4.559 5.45503 4.34C5.66311 4.19814 5.81 3.98299 5.86636 3.73754C5.92271 3.4921 5.88439 3.23442 5.75903 3.016L4.36003 0.580002C4.21752 0.356528 3.99212 0.19877 3.73336 0.141393C3.4746 0.0840151 3.20365 0.131711 2.98003 0.274002C2.34603 0.678002 1.93503 0.964002 1.74603 1.136Z"
            fill={props.fill}
        />
    </svg>
);

CallIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default CallIcon;
