import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CardIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M16 12.5C16 13.3284 15.3284 14 14.5 14H1.5C0.671573 14 0 13.3284 0 12.5V3.5C0 2.67157 0.671573 2 1.5 2H14.5C15.3284 2 16 2.67157 16 3.5V12.5ZM2 4.5C2 4.22386 2.22386 4 2.5 4H3.5C3.77614 4 4 4.22386 4 4.5V5.5C4 5.77614 3.77614 6 3.5 6H2.5C2.22386 6 2 5.77614 2 5.5V4.5ZM2.5 10C2.22386 10 2 10.2239 2 10.5V11.5C2 11.7761 2.22386 12 2.5 12H13.5C13.7761 12 14 11.7761 14 11.5V10.5C14 10.2239 13.7761 10 13.5 10H2.5Z"
            fill={props.fill}
        />
    </svg>
);

CardIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default CardIcon;
