import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ChildrenIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M13.5385 0H15.3846C15.3846 0.615385 15.1795 1.02564 14.7692 1.23077V4.06154C14.7692 4.19749 14.659 4.30769 14.5231 4.30769H13.8678C13.662 4.30769 13.4699 4.20486 13.3558 4.03366L12.9411 3.41158C12.8327 3.77305 12.6951 4.23432 12.5283 4.79541L13.492 9.61365C13.0605 10.0937 12.5715 10.5122 12.0384 10.8609C11.1889 8.54339 9.84274 7.38462 8 7.38462C6.15726 7.38462 4.81114 8.54339 3.96164 10.8609C3.42849 10.5122 2.93952 10.0937 2.50804 9.61365L3.29655 5.6711C3.52667 4.52052 4.53692 3.69231 5.71029 3.69231H8.77048C8.93301 3.06085 9.21767 2.47842 9.59778 1.97171C10.4958 0.774535 11.9267 0 13.5385 0ZM0.816183 6.57769C0.687339 6.26197 0.615385 5.90982 0.615385 5.53846C0.615385 4.17899 1.57969 3.07692 2.76923 3.07692C3.12988 3.07692 3.46983 3.17823 3.76847 3.35729C3.17311 3.76112 2.72425 4.37006 2.52668 5.09449L2.07245 6.75998C1.99702 6.76615 1.92159 6.76923 1.84615 6.76923C1.50283 6.76923 1.15951 6.70538 0.816183 6.57769ZM0 10.7459L0.836372 9.84615C2.46999 11.8932 5.07073 13.2172 8 13.2172C10.9293 13.2172 13.53 11.8932 15.1636 9.84615L16 10.7459C14.526 13.4974 11.4971 15.3846 8 15.3846C4.50287 15.3846 1.47399 13.4974 0 10.7459Z"
            fill={props.fill}
        />
    </svg>
);

ChildrenIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ChildrenIcon;
