import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CloseCircleIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8 16C12.4183 16 16 12.4183 16 8C16 3.58172 12.4183 0 8 0C3.58172 0 0 3.58172 0 8C0 12.4183 3.58172 16 8 16ZM10.4042 4.18162C10.7947 3.7911 11.4279 3.7911 11.8184 4.18162C12.2089 4.57215 12.2089 5.20531 11.8184 5.59584L9.41421 8L11.8184 10.4042C12.2089 10.7947 12.2089 11.4279 11.8184 11.8184C11.4279 12.2089 10.7947 12.2089 10.4042 11.8184L8 9.41421L5.59584 11.8184C5.20531 12.2089 4.57215 12.2089 4.18162 11.8184C3.7911 11.4279 3.7911 10.7947 4.18162 10.4042L6.58579 8L4.18162 5.59584C3.7911 5.20531 3.7911 4.57215 4.18162 4.18162C4.57215 3.7911 5.20531 3.7911 5.59584 4.18162L8 6.58579L10.4042 4.18162Z"
            fill={props.fill}
        />
    </svg>
);

CloseCircleIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default CloseCircleIcon;
