import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ConnectionIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11.9061 2.64569C12.6097 2.70643 13.2204 2.16188 13.2785 1.43074C13.3321 0.699431 12.8085 0.064337 12.1047 0.00392133C11.4069 -0.0517972 10.7915 0.492754 10.7384 1.2239C10.68 1.95034 11.2034 2.59046 11.9061 2.64569Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.734 3.01829C11.055 2.81566 11.3827 2.88806 11.7217 2.91851C12.1579 2.95382 12.5178 3.23582 12.7361 3.5792L14.0201 6.23117L15.7743 7.48678C15.9246 7.60777 16.0167 7.79939 15.9973 8.01108C15.9733 8.33892 15.6967 8.58593 15.382 8.55564C15.2851 8.55062 15.2075 8.51012 15.1202 8.46979L13.2059 7.09837C13.1478 7.048 13.0991 6.98758 13.0607 6.92215L12.5809 5.92893L12.0029 8.5707L14.2625 11.349C14.3157 11.4345 14.3498 11.5353 14.3692 11.636L14.9796 14.9892C14.975 15.0648 14.9843 15.1105 14.9796 15.1708C14.9457 15.6698 14.529 16.0329 14.0542 15.9976C13.6617 15.9623 13.3705 15.6599 13.2788 15.2864L12.7022 12.1451L10.8643 10.0524L10.4379 12.0897C10.4234 12.185 10.3023 12.3871 10.2684 12.4678L8.50461 15.5584C8.33026 15.8405 8.03432 16.0221 7.69994 15.992C7.22016 15.9568 6.86663 15.5232 6.90523 15.029C6.91504 14.8878 6.97326 14.7418 7.02183 14.6409L8.65935 11.782L10.1121 5.64013L9.26538 6.75045L7.90169 8.55742C7.72516 8.78807 7.39903 8.88768 7.14326 8.73154C6.86554 8.56455 6.77572 8.20027 6.93684 7.91147C6.94696 7.88896 6.96159 7.86855 6.97902 7.84328L8.57684 5.73926C8.64051 5.66945 9.97882 3.91756 10.4354 3.31923C10.5299 3.19548 10.734 3.01829 10.734 3.01829Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M2.28579 16C2.91697 16 3.42864 15.4883 3.42864 14.8571C3.42864 14.226 2.91697 13.7143 2.28579 13.7143C1.65461 13.7143 1.14294 14.226 1.14294 14.8571C1.14294 15.4883 1.65461 16 2.28579 16Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M5.51258 10.4584L3.97313 9.25418C3.74458 9.07547 3.41484 9.11636 3.23658 9.34511L3.02127 9.62122L3.00992 9.61207C2.78153 9.4332 2.45148 9.47409 2.27322 9.70269L0.111014 12.4761C-0.0670947 12.7049 -0.0265868 13.0352 0.201644 13.2139L0.212992 13.2229L0.195182 13.2459C0.0167581 13.4745 0.0575812 13.8049 0.285812 13.9836L1.40269 14.8571C1.5083 14.5452 1.79989 14.3193 2.14681 14.3193C2.44849 14.3193 2.70745 14.4909 2.84017 14.74L5.60305 11.1964C5.78148 10.9675 5.74081 10.6371 5.51258 10.4584Z"
            fill={props.fill}
        />
    </svg>
);

ConnectionIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ConnectionIcon;
