import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CrowdIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M9.4 3.40341C9.4 4.17849 8.77733 4.80682 8 4.80682C7.22267 4.80682 6.59 4.17849 6.59 3.40341C6.59 2.62833 7.22267 2 8 2C8.77733 2 9.4 2.62833 9.4 3.40341Z"
            fill={props.fill}
        />
        <path
            d="M5.5 9.4233C5.5 10.0858 5.93018 10.6452 6.5 10.8854V13.4119C6.5 14.2983 7.11107 15 8 15C8.88893 15 9.5 14.3134 9.5 13.4639V10.8854C10.0092 10.6225 10.5003 10.0418 10.5003 9.4233V7.24432C10.5003 6.35796 9.79651 5.28693 8.90758 5.28693H7.09267C6.20374 5.28693 5.5 6.35796 5.5 7.24432V9.4233Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M0 4.71581V2.09101C0.155479 2.0322 0.324033 2 0.5 2C1.27733 2 1.9 2.62833 1.9 3.40341C1.9 4.17849 1.27733 4.80682 0.5 4.80682C0.324033 4.80682 0.155479 4.77462 0 4.71581ZM0 14.919V5.28693H1.40758C2.29651 5.28693 3.00026 6.35796 3.00026 7.24432V9.4233C3.00026 10.0418 2.5092 10.6225 2 10.8854V13.4639C2 14.3134 1.38893 15 0.5 15C0.321186 15 0.153615 14.9716 0 14.919Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M16 5.28693V14.9209C15.8464 14.9722 15.6788 15 15.5 15C14.6111 15 14 14.2983 14 13.4119V10.8854C13.4302 10.6452 13 10.0858 13 9.4233V7.24432C13 6.35796 13.7037 5.28693 14.5927 5.28693H16ZM16 2.09151V4.71531C15.845 4.77444 15.6765 4.80682 15.5 4.80682C14.7227 4.80682 14.09 4.17849 14.09 3.40341C14.09 2.62833 14.7227 2 15.5 2C15.6765 2 15.845 2.03238 16 2.09151Z"
            fill={props.fill}
        />
    </svg>
);

CrowdIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default CrowdIcon;
