import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DeleteIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#3777fbbd__clip0_331_2)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M4 3.00301C4 2.20736 4.31607 1.44429 4.87868 0.881686C5.44129 0.319076 6.20435 0.00300598 7 0.00300598H9C9.79565 0.00300598 10.5587 0.319076 11.1213 0.881686C11.6839 1.44429 12 2.20736 12 3.00301H14C14.2652 3.00301 14.5196 3.10836 14.7071 3.2959C14.8946 3.48344 15 3.73779 15 4.00301C15 4.26822 14.8946 4.52258 14.7071 4.71011C14.5196 4.89765 14.2652 5.00301 14 5.00301H13.346L12.606 14.618C12.577 14.9947 12.407 15.3466 12.1298 15.6034C11.8527 15.8601 11.4888 16.0029 11.111 16.003H4.889C4.51101 16.0031 4.14692 15.8605 3.86955 15.6037C3.59218 15.3469 3.42198 14.9949 3.393 14.618L2.653 5.00301H2C1.73478 5.00301 1.48043 4.89765 1.29289 4.71011C1.10536 4.52258 1 4.26822 1 4.00301C1 3.73779 1.10536 3.48344 1.29289 3.2959C1.48043 3.10836 1.73478 3.00301 2 3.00301H4ZM5.586 5.95301C5.48119 5.9611 5.37899 5.98977 5.28527 6.03737C5.19154 6.08498 5.10811 6.1506 5.03976 6.23047C4.97141 6.31034 4.91947 6.40289 4.8869 6.50285C4.85434 6.60281 4.8418 6.7082 4.85 6.81301L5.275 12.318C5.28314 12.4228 5.31184 12.525 5.35947 12.6187C5.4071 12.7124 5.47271 12.7958 5.55257 12.8641C5.63243 12.9325 5.72497 12.9844 5.8249 13.017C5.92483 13.0496 6.03021 13.0621 6.135 13.054C6.2398 13.0459 6.34196 13.0172 6.43566 12.9695C6.52936 12.9219 6.61277 12.8563 6.68111 12.7764C6.74946 12.6966 6.8014 12.604 6.83398 12.5041C6.86656 12.4042 6.87914 12.2988 6.871 12.194L6.445 6.69001C6.43691 6.58519 6.40824 6.483 6.36063 6.38927C6.31302 6.29555 6.24741 6.21212 6.16754 6.14377C6.08767 6.07541 5.99511 6.02347 5.89516 5.99091C5.7952 5.95835 5.68981 5.94581 5.585 5.95401L5.586 5.95301ZM9.555 6.69501C9.57492 6.4863 9.67597 6.29375 9.83641 6.15879C9.99685 6.02384 10.2039 5.95725 10.4129 5.97337C10.6219 5.98949 10.8163 6.08703 10.9541 6.24499C11.092 6.40295 11.1623 6.60871 11.15 6.81801L10.725 12.311C10.7188 12.4171 10.6914 12.5209 10.6446 12.6163C10.5978 12.7117 10.5325 12.7969 10.4524 12.8668C10.3723 12.9366 10.2791 12.9899 10.1782 13.0233C10.0774 13.0568 9.97084 13.0698 9.86487 13.0616C9.75891 13.0535 9.65563 13.0243 9.56108 12.9757C9.46652 12.9272 9.38259 12.8603 9.31417 12.779C9.24576 12.6976 9.19423 12.6035 9.16261 12.502C9.13099 12.4006 9.1199 12.2938 9.13 12.188L9.555 6.69501ZM7 2.00301C6.73478 2.00301 6.48043 2.10836 6.29289 2.2959C6.10536 2.48344 6 2.73779 6 3.00301H10C10 2.73779 9.89464 2.48344 9.70711 2.2959C9.51957 2.10836 9.26522 2.00301 9 2.00301H7Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="3777fbbd__clip0_331_2">
                <rect width={16} height={16} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

DeleteIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default DeleteIcon;
