import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DisabledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M8.00004 1.42857C8.00004 2.21755 7.36045 2.85714 6.57147 2.85714C5.78249 2.85714 5.1429 2.21755 5.1429 1.42857C5.1429 0.639593 5.78249 0 6.57147 0C7.36045 0 8.00004 0.639593 8.00004 1.42857Z"
            fill={props.fill}
        />
        <path
            d="M5.05132 10.2005C5.26016 10.0527 5.32495 9.7718 5.20192 9.54747L3.88169 7.14007C3.88055 7.13798 3.88037 7.13574 3.88146 7.13362C3.9017 7.09439 4.10804 6.69357 4.18469 6.50985C4.26534 6.31656 4.44364 5.88639 4.44364 5.88639C4.44364 5.88639 4.60671 6.09558 4.79709 6.50985C4.82032 6.5604 4.85078 6.63935 4.88731 6.73406C4.95322 6.90493 5.03893 7.1271 5.13771 7.32637C5.36773 7.86937 5.92124 8.20885 6.52227 8.19936C6.67553 8.19694 6.8102 8.19864 6.89764 8.20741C8.34183 8.35226 9.54135 9.47739 9.69885 10.9759C9.87815 12.6818 8.64057 14.2101 6.93463 14.3894C5.22869 14.5687 3.7004 13.3311 3.52109 11.6252C3.50911 11.5112 3.5119 11.2745 3.5158 11.1096C3.51827 11.0052 3.45099 10.9115 3.3508 10.8818L2.59316 10.6574C2.45839 10.6175 2.32033 10.7073 2.30582 10.8472C2.27746 11.1205 2.24344 11.5365 2.27084 11.7566C2.42585 13.2314 3.29858 14.4571 4.5055 15.1229L3.91613 15.2828C3.75712 15.326 3.64674 15.4703 3.64674 15.6351C3.64674 15.8366 3.81013 16 4.01169 16H14.7903C14.8273 16 14.8572 15.9701 14.8572 15.9331V12.4324C14.8572 12.3729 14.8007 12.3298 14.7434 12.3453L10.3576 13.5352C10.8245 12.7536 11.0516 11.8197 10.9491 10.8445C10.8727 10.1174 10.6218 9.45079 10.2424 8.88202C10.4742 8.86176 10.7115 8.82782 10.7607 8.82062C10.7663 8.8198 10.7714 8.82304 10.7733 8.82833L11.8502 11.7451C11.9501 12.0155 12.2394 12.1653 12.5178 12.0907C12.8096 12.0125 12.9861 11.7163 12.916 11.4225L11.9033 7.17772C11.8977 7.15399 11.8758 7.13771 11.8515 7.13907L8.42002 7.32993C8.2997 7.27494 8.17661 7.22531 8.05107 7.18129C7.95036 6.39361 7.68689 4.7246 7.17877 3.85033C6.49883 2.68043 4.85818 3.26566 3.97056 4.12084C3.12843 4.9322 2.34591 7.24682 2.26793 7.4819C2.2636 7.49493 2.26677 7.50767 2.2754 7.51834L4.36903 10.1062C4.53602 10.3127 4.8346 10.3539 5.05132 10.2005Z"
            fill={props.fill}
        />
    </svg>
);

DisabledIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default DisabledIcon;
