import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DoubleBedIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M2.49876 3C1.67033 3 1 3.67157 1 4.5V8.08525C1.15628 8.03004 1.32446 8 1.49967 8L2 8.00001C2 6.5 3.5 6.5 5 6.5C6.5 6.5 8 6.5 8 8C8 6.5 9.5 6.5 11 6.5H11C12.5 6.5 14 6.5 14 8.00003L14.5003 8.00003C14.6755 8.00003 14.8437 8.03006 15 8.08527V4.5C15 3.67157 14.3297 3 13.5012 3H8H2.49876Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M14.5 13H1.5L1.19089 13.6182C1.11657 13.7669 1.08053 13.8157 1.03182 13.8633C0.983112 13.9108 0.9278 13.945 0.863467 13.9673C0.799133 13.9896 0.739346 14 0.573147 14H0V10.5C0 9.67158 0.671575 9 1.5 9L14.5 9.00004C15.3284 9.00004 16 9.67161 16 10.5V14H15.4269C15.2607 14 15.2009 13.9896 15.1365 13.9673C15.0722 13.945 15.0169 13.9108 14.9682 13.8633C14.9195 13.8157 14.8834 13.7669 14.8091 13.6182L14.5 13Z"
            fill={props.fill}
        />
    </svg>
);

DoubleBedIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default DoubleBedIcon;
