import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DownloadIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7.45442 12.6712C7.75046 12.9852 8.24976 12.9852 8.5458 12.6712L12.1553 8.84301C12.456 8.52403 12.2299 8 11.7915 8H10.0001V1C10.0001 0.447715 9.5524 0 9.00011 0H7.00011C6.44783 0 6.00011 0.447715 6.00011 1V8H4.20874C3.77034 8 3.5442 8.52403 3.84495 8.84301L7.45442 12.6712ZM3 14C2.44772 14 2 14.4477 2 15C2 15.5523 2.44772 16 3 16H13C13.5523 16 14 15.5523 14 15C14 14.4477 13.5523 14 13 14H3Z"
            fill={props.fill}
        />
    </svg>
);

DownloadIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default DownloadIcon;
