import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DryCleaningIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.4879 4.25252C10.4839 2.77886 9.3675 1.74388 8.01419 1.71476C6.6972 1.68642 5.50777 2.80731 5.50777 4.17975C5.50777 4.59136 5.84481 4.92504 6.26058 4.92504C6.67634 4.92504 7.01339 4.59136 7.01339 4.17975C7.01339 3.65261 7.49941 3.1946 7.98147 3.20497C8.54465 3.2171 8.98055 3.62121 8.98228 4.25654C8.98332 4.63977 8.66932 5.02619 7.90217 5.42136C7.49978 5.62865 7.24734 6.0404 7.24734 6.48948L7.24748 7.22464C7.24748 7.87103 7.62592 8.45883 8.21779 8.73174L12.1979 10.5248C12.4772 10.6408 12.6013 10.8131 12.5777 10.9695C12.5463 11.1776 12.2719 11.4312 12.1641 11.4312H3.83707C3.72489 11.4312 3.45583 11.1839 3.42343 10.9695C3.39895 10.8075 3.51826 10.6432 3.77537 10.537L6.00716 9.51399C6.38266 9.33727 6.54235 8.89265 6.36384 8.52091C6.18534 8.14917 5.73623 7.99107 5.36074 8.16779L1.53456 9.96852C0.726369 10.3015 0.168784 11.0694 0.306746 11.9825C0.446099 12.9047 1.32696 13.7142 2.20944 13.7142H13.7911C14.6712 13.7142 15.5557 12.8968 15.6938 11.9825C15.8305 11.0778 15.2698 10.2997 14.4328 9.95384L8.85347 7.38054C8.79225 7.35231 8.7531 7.2915 8.7531 7.22464V6.66055C9.87204 6.04372 10.4906 5.23942 10.4879 4.25252Z"
            fill={props.fill}
        />
    </svg>
);

DryCleaningIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default DryCleaningIcon;
