import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ExitFullscreenIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M4.29983 10.7859V10.4625L3.15009 10.7768C2.61233 10.9238 2.05733 10.9983 1.49983 10.9983C0.899825 10.9983 0.499825 10.5506 0.499825 9.99724C0.499825 9.44496 0.94754 8.99724 1.49983 8.99724H5.99983C6.55211 8.99724 6.99983 9.44496 6.99983 9.99724V14.5018C6.99983 15.054 6.55211 15.5018 5.99983 15.5018C5.44754 15.5018 4.99983 15.099 4.99983 14.5018C4.99983 13.9424 5.0745 13.3856 5.22187 12.8461L5.53516 11.699H5.21418L4.13645 13.1359C3.8522 13.5149 3.54137 13.8732 3.20632 14.2081L2.20404 15.2103C1.81344 15.6007 1.18027 15.6006 0.789825 15.21C0.399377 14.8194 0.399501 14.1862 0.790102 13.7958L1.79369 12.7923C2.12629 12.4598 2.48193 12.1512 2.85796 11.8688L4.29983 10.7859ZM11.6998 5.20436V5.52773L12.8496 5.21343C13.3873 5.06642 13.9423 4.99192 14.4998 4.99192C15.0998 4.99192 15.4998 5.43964 15.4998 5.99301C15.4998 6.5453 15.0521 6.99301 14.4998 6.99301H9.99983C9.44754 6.99301 8.99983 6.5453 8.99983 5.99301V1.4885C8.99983 0.936218 9.44754 0.488502 9.99983 0.488502C10.5521 0.488502 10.9998 0.891241 10.9998 1.4885C10.9998 2.04782 10.9251 2.60464 10.7778 3.1442L10.4645 4.29124H10.7855L11.8632 2.85436C12.1475 2.47537 12.4583 2.11707 12.7933 1.78215L13.7956 0.779999C14.1862 0.389551 14.8194 0.389675 15.2098 0.780275C15.6003 1.17088 15.6001 1.80404 15.2095 2.19449L14.206 3.19795C13.8734 3.53042 13.5177 3.83901 13.1417 4.12143L11.6998 5.20436Z"
            fill={props.fill}
        />
    </svg>
);

ExitFullscreenIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ExitFullscreenIcon;
