import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FemaleIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M5.75187 4.08008C5.82401 4.06167 6.00342 4 6.50342 4C6.7425 4.53284 7.19821 4.9107 8.00341 4.9107C8.8199 4.9107 9.33936 4.53284 9.50342 4C10.0034 4 10.192 4.05483 10.2903 4.0799C10.5305 4.14118 10.6905 4.3225 10.7153 4.53284L11.0001 6.95413C11.0302 7.21065 10.8545 7.45231 10.5665 7.53949C10.353 7.60412 9.78786 7.65326 9.50342 7.73075L10.9101 11.5794C10.9314 11.6529 10.9167 11.7305 10.8529 11.7837C10.7115 11.9014 10.2647 12.11 9.58936 12.2543L9.45792 15.4641C9.43405 15.7657 9.13667 16 8.77782 16H8.34871L8.19092 12.4107C8.13862 12.4114 8.05759 12.4107 8.00342 12.4107C7.94925 12.4107 7.85394 12.4114 7.80164 12.4107L7.58545 16H7.15635C6.7975 16 6.50011 15.7657 6.47624 15.4641L6.35107 12.2543C5.67575 12.11 5.21112 11.9014 5.0698 11.7837C5.00596 11.7305 4.99124 11.6529 5.01256 11.5794L6.4113 7.73075C6.16707 7.66308 5.65784 7.59618 5.47117 7.5397C5.18273 7.45243 5.00688 7.21026 5.03759 6.9534L5.32703 4.53217C5.35214 4.32219 5.51209 4.14129 5.75187 4.08008Z"
            fill={props.fill}
        />
        <path
            d="M6.69161 1.44733C6.61236 0.672413 7.23471 0 8.03119 0C8.75262 0 9.3312 0.551668 9.37493 1.23149L9.56298 1.04762C10.0114 0.609205 10.6519 0.624611 11.0858 1.08424L12.122 2.18182L11.7058 2.58875C11.2575 3.02716 10.6169 3.01175 10.183 2.55212L9.34821 1.66789L9.25791 2.55087C9.19489 3.16709 8.66456 3.63636 8.03119 3.63636C7.39782 3.63636 6.8675 3.16709 6.80447 2.55087L6.69161 1.44733Z"
            fill={props.fill}
        />
    </svg>
);

FemaleIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default FemaleIcon;
