import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FireIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8Z"
            fill={props.fill}
        />
        <path
            d="M6.06148 13.9998C4.72754 9.60432 7.54612 7.9994 7.54612 7.9994C7.34891 10.3449 8.6818 12.1722 8.6818 12.1722C9.17202 12.0243 10.1077 11.333 10.1077 11.333C10.1077 12.1722 9.61399 13.9988 9.61399 13.9988C9.61399 13.9988 11.3423 12.6624 11.8864 10.4428C12.4298 8.22318 10.8514 5.99482 10.8514 5.99482C10.9465 7.56582 10.415 9.11095 9.37377 10.2914C9.42587 10.2313 9.46958 10.1645 9.50315 10.0921C9.69021 9.71796 9.99057 8.74556 9.81469 6.49378C9.56713 3.33289 6.7031 2 6.7031 2C6.94996 3.92591 6.20974 4.36962 4.47579 8.02527C2.74185 11.6802 6.06148 13.9998 6.06148 13.9998Z"
            fill="white"
        />
    </svg>
);

FireIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default FireIcon;
