import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FitnessIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.7063 6.66666C10.7502 5.78148 10.8305 4.65157 10.9472 3.27692C10.9765 2.93185 11.2652 2.66667 11.6115 2.66667L11.7408 2.66666C12.0805 2.66666 12.3658 2.92208 12.4033 3.25971C12.5789 4.83981 12.6667 6.4199 12.6667 8C12.6667 9.58009 12.5789 11.1602 12.4033 12.7403C12.3658 13.0779 12.0804 13.3333 11.7407 13.3333L11.6115 13.3333C11.2652 13.3333 10.9765 13.0681 10.9472 12.7231L10.9472 12.7231C10.8305 11.3484 10.7502 10.2185 10.7063 9.33332H5.2924C5.24816 10.2099 5.16807 11.3396 5.05213 12.7223L5.05215 12.7223C5.02319 13.0677 4.7344 13.3333 4.3878 13.3333L4.25926 13.3333C3.91955 13.3333 3.63417 13.0779 3.59666 12.7403C3.42111 11.1602 3.33333 9.58009 3.33333 8C3.33333 6.4199 3.42111 4.83981 3.59666 3.25971C3.63417 2.92208 3.91955 2.66666 4.25925 2.66666L4.38781 2.66667C4.7344 2.66667 5.02317 2.93225 5.05213 3.27762C5.16807 4.66042 5.24816 5.79009 5.2924 6.66666H10.7063ZM1.03704 9.33332H0.854628C0.557456 9.33332 0.449693 9.30238 0.341051 9.24428C0.232409 9.18618 0.147147 9.10091 0.0890442 8.99227C0.0309419 8.88363 0 8.77587 0 8.47869V7.52129C0 7.22411 0.0309419 7.11635 0.0890442 7.00771C0.147147 6.89907 0.232409 6.8138 0.341051 6.7557C0.449693 6.6976 0.557456 6.66666 0.854628 6.66666H1.03704C1.07582 5.96858 1.14506 5.27049 1.24476 4.57241L1.24475 4.57241C1.29165 4.24396 1.57294 3.99999 1.90473 3.99999H2C2.36819 3.99999 2.66667 4.29847 2.66667 4.66666V11.3333C2.66667 11.7015 2.36819 12 2 12L1.9047 12C1.57294 12 1.29166 11.756 1.24476 11.4276C1.14506 10.7295 1.07582 10.0314 1.03704 9.33332ZM14.963 6.66666H15.1454C15.4425 6.66666 15.5503 6.6976 15.6589 6.7557C15.7676 6.8138 15.8529 6.89907 15.911 7.00771C15.9691 7.11635 16 7.22411 16 7.52129V8.47869C16 8.77587 15.9691 8.88363 15.911 8.99227C15.8529 9.10091 15.7676 9.18618 15.6589 9.24428C15.5503 9.30238 15.4425 9.33332 15.1454 9.33332H14.963C14.9242 10.0314 14.8549 10.7295 14.7552 11.4276C14.7083 11.756 14.4271 12 14.0953 12L14 12C13.6318 12 13.3333 11.7015 13.3333 11.3333V4.66666C13.3333 4.29847 13.6318 3.99999 14 3.99999H14.0953C14.4271 3.99999 14.7083 4.24396 14.7553 4.57241L14.7552 4.57241C14.8549 5.27049 14.9242 5.96858 14.963 6.66666Z"
            fill={props.fill}
        />
    </svg>
);

FitnessIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default FitnessIcon;
