import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FlightIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M14.0001 1.0802C14.4934 0.926864 14.8734 0.906864 15.0001 1.03353C15.1267 1.1602 15.1067 1.5402 14.9534 2.03353C14.6248 3.03475 14.0705 3.9471 13.3334 4.7002L12.0001 6.03353L12.6667 14.7002L12.0001 15.3669L9.08217 8.94745C8.5379 9.47008 7.95319 9.94917 7.33342 10.3802C6.96122 10.6678 6.56902 10.9266 6.16028 11.155L6.66675 14.7002L6.00008 15.3669L4.00008 12.0335L0.666748 10.0335L1.33341 9.36686L4.88289 9.87393C5.11057 9.46549 5.36795 9.07314 5.65342 8.7002C6.15341 7.98534 6.71559 7.31607 7.33342 6.7002L11.3334 2.7002C12.0865 1.9631 12.9989 1.40885 14.0001 1.0802ZM1.33341 3.36686L0.666748 4.03353L6.26008 6.57353C7.03206 5.62881 7.87928 4.74816 8.79342 3.9402L1.33341 3.36686Z"
            fill={props.fill}
        />
    </svg>
);

FlightIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default FlightIcon;
